package com.vf106.tools.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Bundle;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.LinearLayout;

import com.vf106.tools.R;
import com.vf106.tools.activity.base.BaseActivity;
import com.vf106.tools.bean.BaseBean;
import com.vf106.tools.utils.Constants;

import java.io.IOException;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

/**
 * Dual camera display test
 */
public class CameraActivity extends BaseActivity implements View.OnClickListener {
    SurfaceHolder holder1;
    SurfaceHolder holder2;
    Camera mCamera1;
    Camera mCamera2;
    private SurfaceView surfaceView1;
    private SurfaceView surfaceView2;
    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_camera);
    }

    @Override
    protected void initViews() {
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);

        surfaceView1 = findViewById(R.id.surfaceView1);
        surfaceView2 = findViewById(R.id.surfaceView2);
        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);
    }

    @Override
    protected void setTitle() {
        setActionBarTitle("Dual camera display test");
    }

    @Override
    protected void setListener() {
        holder1 = surfaceView1.getHolder();
        holder1.addCallback(new SurfaceHolder.Callback() {
            @Override
            public void surfaceCreated(SurfaceHolder holder) {
            }

            @Override
            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                try {
                    mCamera1.setPreviewDisplay(holder);
                    mCamera1.startPreview();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        });

        holder2 = surfaceView2.getHolder();
        holder2.addCallback(new SurfaceHolder.Callback() {
            @Override
            public void surfaceCreated(SurfaceHolder holder) {
            }

            @Override
            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                try {
                    mCamera2.setPreviewDisplay(holder);
                    mCamera2.startPreview();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        });

        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {

    }

    @Override
    protected void onResume() {
        super.onResume();
        mCamera1 = Camera.open(0);
        mCamera1.setDisplayOrientation(90);
        mCamera2 = Camera.open(1);
        mCamera2.setDisplayOrientation(90);
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mCamera1 != null) {
            mCamera1.stopPreview();
            mCamera1.release();
        }
        if (mCamera2 != null) {
            mCamera2.stopPreview();
            mCamera2.release();
        }
    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }
}
